#include <inttypes.h>
#include "glcd.h"


void GlcdClear(void)
{
	ks0108Fill( CLEAR );
};

void PrintAt ( uint8_t x , uint8_t y , char *string, struct font font)
{
	ks0108GotoXY( x, y);
	ks0108PutString( string, font);
};

void Print ( char *string, struct font font )
{
	ks0108PutString( string, font);
};

void GlcdSetDot(uint8_t x, uint8_t y)
{
	ks0108SetDot(x,y);
};

void GlcdClearDot(uint8_t x, uint8_t y)
{
	ks0108ClearDot(x,y);
};

void LineX(uint8_t y, uint8_t x1, uint8_t x2)
{
	uint8_t i;
	for (i = x1; i < x2; i++)
	{
		GlcdSetDot(i, y);
	}
}

void LineY(uint8_t x, uint8_t y1, uint8_t y2)
{
	uint8_t i;
	for (i = y1; i < y2; i++)
	{
		GlcdSetDot(x, i);
	}
}

void DrawBox(uint8_t x, uint8_t y, uint8_t width, uint8_t height)
{
	LineX(y , x, x + width);
	LineX(y + height , x, x + width);
	LineY(x, y, y + height);
	LineY(x + width, y, y + width);
};
	